/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CRebar.h,v 1.2 1999/09/17 04:20:48 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CRebar_h	// [
#define Included_CRebar_h

#include "pgpClassesConfig.h"
#include <commctrl.h>

#include "UMath.h"
#include "CWindow.h"

_PGP_BEGIN

// Class CRebar

class CRebar : public CWindow
{
public:
	CRebar() { }
	~CRebar() { }

	PGPInt32	InsertBand(PGPInt32 index, const REBARBANDINFO& bandInfo)
	{
		return SendMessage(RB_INSERTBAND, index, 
			reinterpret_cast<LPARAM>(&bandInfo));
	}

	PGPInt32	SetBandInfo(PGPUInt32 index, const REBARBANDINFO& bandInfo)
	{
		return SendMessage(RB_SETBANDINFO, index, 
			reinterpret_cast<LPARAM>(&bandInfo));
	}

	PGPInt32	SetBarInfo(const REBARINFO& barInfo)
	{
		return SendMessage(RB_SETBARINFO, 0, 
			reinterpret_cast<LPARAM>(&barInfo));
	}

	void	Create(HWND parent, PGPUInt32 id, PGPUInt32 style, 
		PGPInt32 xOffset = 0, PGPInt32 yOffset = 0, PGPInt32 width = 0, 
		PGPInt32 height = 0);
};

_PGP_END

#endif	// ] Included_CRebar_h
